/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.lpar;

import com.ibm.hsc.auiml.databeans.lpar.PILparRebootDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscBaseException;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.jcb.RemoteSourceException;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.bridge.WSessionMgr;
import com.ibm.websm.console.WWorkingDialog;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EWorkingListener;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.BitSet;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt8;

public class PILparRebootDialog
implements TaskActionListener {
    private static final String AUIML_CLASS_NAME = "com.ibm.hsc.auiml.databeans.lpar.PILparRebootPanel";
    private static final String PROP_PANEL = "PILparRebootPanel";
    private UserTaskManager m_utm = null;
    private String m_confirmMsg = "";
    private String m_methName = "";
    private String m_title = "";
    private String[] m_lparIDs;
    private String[] m_lparNames;
    private String[] m_lparUserDefNames;
    private PILparRebootDataBean m_rebootBean;
    private Vector m_objects;
    private boolean m_allOS400Lpars = true;
    private boolean m_allRpaLpars = true;
    private boolean m_enableOSCmd = true;
    private boolean m_enableNormal = true;
    private boolean m_enableImmediate = true;
    private boolean m_enableRetry = true;
    static /* synthetic */ Class class$com$ibm$websm$etc$EWorkingListener;

    public PILparRebootDialog(Vector vector) {
        this.m_objects = vector;
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            this.m_lparIDs = new String[n];
            this.m_lparNames = new String[n];
            this.m_lparUserDefNames = new String[n];
            for (int i = 0; i < n; ++i) {
                UnsignedInt8[] unsignedInt8Array;
                Object object;
                MOXContainerObj mOXContainerObj = (MOXContainerObj)vector.elementAt(i);
                this.m_lparNames[i] = mOXContainerObj.getKey();
                this.m_lparIDs[i] = this.m_lparNames[i].substring(0, this.m_lparNames[i].indexOf(42));
                this.m_lparUserDefNames[i] = mOXContainerObj.getName();
                if (this.m_allOS400Lpars || this.m_allRpaLpars) {
                    object = (String)mOXContainerObj.getPropertyValue("partitionType_PROP");
                    if (((String)object).equals(HSCResourceBundleUtil.getMessage("ProfileBundle", "OSTYPE_OS400"))) {
                        this.m_allRpaLpars = false;
                    } else {
                        this.m_allOS400Lpars = false;
                    }
                }
                if ((object = (Long)mOXContainerObj.getPropertyValue("SysCmdCapabilities")) == null || ((Long)object).intValue() == 0) {
                    this.m_enableOSCmd = false;
                }
                if ((unsignedInt8Array = (UnsignedInt8[])mOXContainerObj.getPropertyValue("VirtualPanelFunctions")) == null || unsignedInt8Array.length == 0) {
                    System.out.println("In reboot dialog, SuppVirtualPanelFunctions is null or empty, disable all panels.");
                    this.m_enableNormal = false;
                    this.m_enableImmediate = false;
                    this.m_enableRetry = false;
                    continue;
                }
                byte[] byArray = new byte[unsignedInt8Array.length];
                for (int j = 0; j < unsignedInt8Array.length; ++j) {
                    byArray[j] = unsignedInt8Array[j].byteValue();
                }
                BitSet bitSet = ByteUtilities.byteArrayToBitSet(byArray);
                Vector vector2 = PIHscUtil.returnSuppVirPanelFuncsVec(bitSet);
                if (!vector2.contains(new Integer(3))) {
                    this.m_enableImmediate = false;
                }
                if (!vector2.contains(new Integer(22))) {
                    this.m_enableNormal = false;
                }
                if (vector2.contains(new Integer(34))) continue;
                this.m_enableRetry = false;
            }
        }
    }

    public void showDialog() {
        try {
            this.loadBeans();
            DataBean[] dataBeanArray = new DataBean[]{this.m_rebootBean};
            AuimlAdapter auimlAdapter = new AuimlAdapter(AUIML_CLASS_NAME, PROP_PANEL, dataBeanArray);
            this.m_utm = auimlAdapter.getUserTaskManager();
            if (!this.m_allOS400Lpars) {
                this.m_utm.setShown("DumpRestart", false);
            }
            if (!this.m_allRpaLpars) {
                System.out.println("got os/400 lpar");
                this.m_utm.setShown("OSReset", false);
                this.m_utm.setShown("OSResetImmd", false);
            }
            if (!this.m_enableOSCmd) {
                System.out.println("DIsable OS CMD.");
                this.m_utm.setEnabled("OSReset", false);
                this.m_utm.setEnabled("OSResetImmd", false);
            }
            if (!this.m_enableNormal) {
                System.out.println("DIsable Normal reboot.");
                this.m_utm.setEnabled("Normal", false);
                String[] stringArray = new String[]{"Immediate"};
                this.m_rebootBean.setOptionsSelection(stringArray);
            }
            if (!this.m_enableImmediate) {
                System.out.println("DIsable Immediate reboot.");
                this.m_utm.setEnabled("Immediate", false);
            }
            if (!this.m_enableRetry) {
                System.out.println("DIsable retry reboot.");
                this.m_utm.setEnabled("DumpRestart", false);
            }
            this.m_rebootBean.setUTM(this.m_utm);
            this.m_utm.addTaskActionListener((TaskActionListener)this);
            auimlAdapter.showIt();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            new TaskMessage(this.m_utm, HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "0631"), HSCResourceBundleUtil.getMessage("LPARBundle", "REBOOT_PARTITION"), 1, null, null).invoke();
        }
    }

    private void loadBeans() {
        this.loadRebootBean();
    }

    private void loadRebootBean() {
        this.m_rebootBean = new PILparRebootDataBean();
        ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[this.m_lparIDs.length];
        ItemDescriptor[] itemDescriptorArray2 = new ItemDescriptor[this.m_lparIDs.length];
        for (int i = 0; i < this.m_lparIDs.length; ++i) {
            itemDescriptorArray[i] = new ItemDescriptor(this.m_lparUserDefNames[i], this.m_lparUserDefNames[i]);
            itemDescriptorArray2[i] = new ItemDescriptor(this.m_lparNames[i], this.m_lparIDs[i]);
        }
        this.m_rebootBean.setLparIDsList(itemDescriptorArray2);
        this.m_rebootBean.setLparNamesList(itemDescriptorArray);
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        block15: {
            try {
                int n;
                this.m_utm.storeAllElements();
                if (IDebug.enabled()) {
                    System.err.println("Event is : " + taskActionEvent);
                }
                WWorkingDialog wWorkingDialog = new WWorkingDialog(this.m_title);
                EWorkingListener eWorkingListener = (EWorkingListener)WSessionMgr.getProxy((String)(class$com$ibm$websm$etc$EWorkingListener == null ? (class$com$ibm$websm$etc$EWorkingListener = PILparRebootDialog.class$("com.ibm.websm.etc.EWorkingListener")) : class$com$ibm$websm$etc$EWorkingListener).getName(), (Object)wWorkingDialog);
                MOClass mOClass = null;
                mOClass = ((MOXContainerObj)this.m_objects.elementAt(0)).getMOClass();
                String[] stringArray = this.m_rebootBean.getOptionsSelection();
                String string = "Normal";
                if (stringArray != null && stringArray.length > 0) {
                    System.out.println("options = " + stringArray[0]);
                    string = stringArray[0];
                }
                if (string.equals("Immediate") && !this.m_allRpaLpars && (n = new TaskMessage(this.m_utm, HSCResourceBundleUtil.getMessage("LPARBundle", "REBOOT_OS400_PARTITION_WARNING"), HSCResourceBundleUtil.getMessage("LPARBundle", "REBOOT_PARTITION"), 3, new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "YES"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO")}, HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO")).invoke()) != 0) {
                    return;
                }
                try {
                    Object[] objectArray = new Object[]{string, this.m_objects, eWorkingListener};
                    mOClass.invokeStaticMethod("lparRebootOp", objectArray);
                }
                catch (RemoteSourceException remoteSourceException) {
                    try {
                        HSCLogUtils.clientLog(remoteSourceException, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Throwable throwable = remoteSourceException.getSourceException();
                    if (throwable instanceof PIHscBaseException) {
                        new TaskMessage(this.m_utm, throwable.getMessage(), HSCResourceBundleUtil.getMessage("LPARBundle", "REBOOT_PARTITION"), 1, null, null).invoke();
                        break block15;
                    }
                    new TaskMessage(this.m_utm, HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "0632"), HSCResourceBundleUtil.getMessage("LPARBundle", "REBOOT_PARTITION"), 1, null, null).invoke();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    new TaskMessage(this.m_utm, HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "0632"), HSCResourceBundleUtil.getMessage("LPARBundle", "REBOOT_PARTITION"), 1, null, null).invoke();
                }
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throwable.printStackTrace();
                new TaskMessage(this.m_utm, HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "0632"), HSCResourceBundleUtil.getMessage("LPARBundle", "REBOOT_PARTITION"), 1, null, null).invoke();
                this.m_utm.dispose();
                return;
            }
        }
        this.m_utm.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

